<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

// Get css class
$class     = 'insight-title';
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $this->settings['base'], $atts );
$el_class  = $this->getExtraClass( $el_class );
if ( $el_class != '' ) {
	$class .= ' ' . $el_class;
}
if ( $css_class != '' ) {
	$class .= ' ' . $css_class;
}
if ( $style ) {
	$class .= ' style-' . $style;
}
?>
<div
	class="<?php echo esc_attr( $class ) ?>" <?php echo( $style == 'color' ? 'style="color: ' . $color . '; border-color: ' . $color . '"' : '' ); ?>>
	<div class="insight-title--title"><?php echo esc_attr( $title ) ?></div>
	<?php if ( $sub_title_enable == 'yes' ): ?>
		<div class="insight-title--subtitle">
			<?php echo esc_attr( $sub_title ) ?>
		</div>
	<?php endif; ?>
	<?php if ( $separator_enable == 'yes' ): ?>
		<div
			class="insight-separator vc_separator wpb_content_element vc_separator_align_center vc_sep_pos_align_center vc_separator-has-text">
			<span class="vc_sep_holder vc_sep_holder_l"><span class="vc_sep_line"></span></span>
			<div class="insight-separator--icon vc_icon_element vc_icon_element-outer">
				<i class="organik-flower"></i>
			</div>
			<span class="vc_sep_holder vc_sep_holder_r"><span class="vc_sep_line"></span></span>
		</div>
	<?php endif; ?>
</div>
