<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'insight-btn';

// Get css class
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $this->settings['base'], $atts );
$el_class  = $this->getExtraClass( $el_class );

if ( $css_class != '' ) {
	$class .= ' ' . $css_class;
}

if ( $el_class != '' ) {
	$class .= ' ' . $el_class;
}

if ( $style ) {
	$class .= ' style-' . $style;
}

// Get link
$link_html   = '';
$link        = vc_build_link( $link );
$link_url    = ( isset( $link['url'] ) ) ? $link['url'] : '';
$link_text   = ( isset( $link['title'] ) ) ? $link['title'] : '';
$link_target = ( isset( $link['target'] ) ) ? $link['target'] : '';
$link_rel    = ( isset( $link['rel'] ) ) ? $link['rel'] : '';

if ( ! empty( $link_text ) ) {
	echo '<a class="' . esc_attr( $class ) . '" href="' . esc_url( $link_url ) . '" target="' . esc_attr( $link_target ) . '" rel="' . esc_attr( $link_rel ) . '">' . esc_html( $link_text ) . '</a>';
}
?>
