<?php
/**
* Displays custom settings in WooCommerce backend for product variant
*
* @package PricePerUnit/Admin
* @var string $loop Id of the pass of variant
* @var array $variation_data Passed information about the variant
* @var object $variation Object containing the variation
*/

if (!defined('ABSPATH')):
    exit; // Exit if accessed directly
endif;
?>
<div class="variation-custom-fields">
    <p>
        <span class="section-heading"><?php esc_html_e('Price Per Unit', 'woo-price-per-unit-pro');?></span></br>
        <?php
        woocommerce_wp_text_input(
            array(
                'id' => '_mcmp_ppu_cust_num_of_units_override'. $loop ,
                'label' => esc_html__('Custom number of units', 'woo-price-per-unit-pro'),
                'description' => esc_html__("For more information look at tab 'Price per unit' - this is variation override. Warning - use with caution - changes visible price.", 'woo-price-per-unit-pro'),
                'placeholder' => esc_html__('Enter number of units in decimal form - default is 0 or empty', 'woo-price-per-unit-pro'),
                'default' => '',
                'type' => 'text',
                'data_type' => 'decimal',
                'desc_tip' => true,
                'value' => get_post_meta($variation->ID, '_mcmp_ppu_cust_num_of_units_override', true),
            )
        );
		if( 'yes' == get_option('_mcmp_ppu_var_option_add_gen_suff_texts')) { 
			woocommerce_wp_text_input(
				array(
					'id' => '_mcmp_ppu_additional_text_override'. $loop ,
					'label' => esc_html__('General price suffix text', 'woo-price-per-unit-pro'),
					'description' => '</br>' . esc_html__("This text will be shown only after selected option price text. You can modify it's appearance through CSS class mcmp-variation-option-price-suffix.", 'woo-price-per-unit-pro'),
					'placeholder' => esc_html__('Example "Without Vat"', 'woo-price-per-unit-pro'),
					'default' => '',
					'type' => 'text',
					'desc_tip' => false,
					'value' => get_post_meta($variation->ID, '_mcmp_ppu_additional_text_override', true),
				)
			);
		}
        woocommerce_wp_checkbox(
            array(
                'id' => '_mcmp_ppu_var_show_recalc'. $loop ,
                'label' => esc_html__('Show calculation for this variant', 'woo-price-per-unit-pro'),
                'description' => esc_html__("Works only together with the setting 'New row - selected variants only' under Shop page price behavior.", 'woo-price-per-unit-pro'),
                'wrapper_class' => 'mcmp_ppu_var_show_recalc_checkbox',
                'desc_tip' => false,
                'value' => get_post_meta($variation->ID, '_mcmp_ppu_var_show_recalc', true),
            )
        );
        ?>
    </p>
</div>