<?php
/**
 * Displays custom settings in WooCommerce backend for product variant
 *
 * @package PricePerUnit/Admin
 * @var array $value Information about the field
 */

if ( ! defined( 'ABSPATH' ) ) :
	exit; // Exit if accessed directly.
endif;

$description = WC_Admin_Settings::get_field_description( $value );
$id          = esc_attr( $value['id'] );
?>
<tr valign="top">
	<th scope="row" class="titledesc">
		<label for="<?php echo $id . '_to_check'; ?>"><?php echo esc_html( $value['title'] ); ?></label>
		<?php echo esc_html( $description['tooltip_html'] ); ?>
	</th>
	<td class="forminp forminp-mcmplicence">
	<form action="" method="post">
					<input
						name= "<?php echo $id . '_to_check'; ?>"
						id= "<?php echo $id . '_to_check'; ?>"
						type="text"
						value="<?php echo esc_attr( get_option( $id . '_key' ) ); ?>"
						placeholder="<?php echo esc_attr( $value['placeholder'] ); ?>"
					/><?php echo ( array_key_exists( 'suffix', $value ) ) ? esc_html( $value['suffix'] ) : ''; ?>
					<?php echo esc_html( $description['description'] ); ?>
		<div class="submit-wrapper">
		<button
				name ="<?php echo 'activate' . $id; ?>"
				id   ="<?php echo $id . '_activate'; ?>"
				type ="submit"
				class="button-primary"
				>
				<?php echo esc_attr__( 'Activate', 'woo-price-per-unit-pro' ); ?>
			</button>
			<button
				name ="<?php echo 'deactivate' . $id; ?>"
				id   ="<?php echo $id . '_deactivate'; ?>"
				type ="submit"
				class="button"
				>
				<?php echo esc_attr__( 'Deactivate', 'woo-price-per-unit-pro' ); ?>
			</button>
		</div>
	</form>
	<p class="description"><?php echo esc_attr__( 'Note: If you want to ask your money back during the 14 days after the purchase, please deactivate the licence first.', 'woo-price-per-unit-pro' ); ?></p>
	<p class="description"><?php echo esc_attr__( 'Note: In case you want to move the licence to some other domain, deactivate the licence and activate the licence key again on the new domain.', 'woo-price-per-unit-pro'  ); ?></p>
	</td>
</tr>