
<?php
/**
* Displays custom settings in WooCommerce backend for product variant
*
* @package PricePerUnit/Admin
* @var array $value Information about the field
*/
if (!defined('ABSPATH')):
    exit; // Exit if accessed directly
endif;

$field_description = WC_Admin_Settings::get_field_description( $value );
$description       = $field_description['description'];
$tooltip_html      = $field_description['tooltip_html'];
$custom_attributes = array();
if ( ! empty( $value['custom_attributes'] ) && is_array( $value['custom_attributes'] ) ) {
    foreach ( $value['custom_attributes'] as $attribute => $attribute_value ) {
        $custom_attributes[] = esc_attr( $attribute ) . '="' . esc_attr( $attribute_value ) . '"';
    }
}
?>
<tr valign="top">
    <th scope="row" class="titledesc">
        <label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo esc_html( $value['title'] ); ?> <?php echo $tooltip_html; // WPCS: XSS ok. ?></label>
    </th>
    <td class="forminp forminp-<?php echo esc_attr( sanitize_title( $value['type'] ) ); ?>">
        <button class="<?php echo esc_attr( $value['class'] ); ?>"
            id="<?php echo esc_attr( $value['id'] ); ?>"
            name="<?php echo esc_attr( $value['id'] ); ?>"
            type="<?php echo esc_attr( $value['button_type'] ); ?>"
            style="<?php echo esc_attr( $value['css'] ); ?>"
            value="<?php echo esc_attr( $value['value'] ); ?>"
            <?php echo implode( ' ', $custom_attributes ); // WPCS: XSS ok. ?>
        >
            <?php echo esc_html( $value['button_text'] ); ?>
        </button>
        <?php echo $description; // WPCS: XSS ok. ?>
    </td>
</tr>