<?php
/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     3.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post, $product, $woocommerce;

if ( method_exists( $product, 'get_gallery_image_ids' ) ) {
	// woo 3.x
	$attachment_ids = $product->get_gallery_image_ids();
} else {
	// woo 2.x
	$attachment_ids = $product->get_gallery_attachment_ids();
}

if ( $attachment_ids ) {
	$loop    = 0;
	$columns = apply_filters( 'woocommerce_product_thumbnails_columns', 3 );
	?>
	<div class="thumbnails <?php echo 'columns-' . $columns; ?>">
		<?php
		foreach ( $attachment_ids as $attachment_id ) {
			$props = wc_get_product_attachment_props( $attachment_id, $post );

			if ( ! $props['url'] ) {
				continue;
			}

			echo sprintf(
				'<div class="item"><a href="%s" data-src="%s">%s</a></div>',
				esc_url( $props['url'] ),
				esc_url( $props['url'] ),
				wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ), 0 )
			);

			$loop ++;
		}
		?>
	</div>
	<?php
}
