<?php

/**
* Public funcions - some of them are supposed to override 
* funcions included by WooCommere in woocommerce\includes\wc-template-functions.php
* which are loaded by the hook add_action( 'after_setup_theme', array( $this, 'include_template_functions' ), 11 );
*
* @package PricePerUnit/Admin
*/

if (!defined('ABSPATH')):
    exit; // Exit if accessed directly
endif;

if ( ! function_exists( 'mcmp_wp_select_multiple' ) ) {
    /**
     * Displays multiselect field in woocommerce product settings
     * @param array $field - attributes of the new multiselect field
    */
    function mcmp_wp_select_multiple( $field ) {
        global $thepostid, $post;

        
        $thepostid              = empty( $thepostid ) ? $post->ID : $thepostid;
        $field['class']         = isset( $field['class'] ) ? $field['class'] : 'select short';
        $field['wrapper_class'] = isset( $field['wrapper_class'] ) ? $field['wrapper_class'] : '';
        $field['name']          = isset( $field['name'] ) ? $field['name'] : $field['id'].'[]';
        $field['value']         = isset( $field['value'] ) ? $field['value'] : ( get_post_meta( $thepostid, $field['id'], true ) ? get_post_meta( $thepostid, $field['id'], true ) : array() );

        echo '<p class="form-field ' . esc_attr( $field['id'] ) . '_field ' . esc_attr( $field['wrapper_class'] ) . '">
            <label for="' . esc_attr( $field['id'] ) . '">' . wp_kses_post( $field['label'] ) . '</label>
            <select id="' . esc_attr( $field['id'] ) . '" name="' . esc_attr( $field['name'] ) . '" class="wc-enhanced-select" multiple="multiple">';

        foreach ( $field['options'] as $key => $value ) {
            echo '<option value="' . esc_attr( $key ) . '" ' . ( in_array( $key, $field['value'] ) ? 'selected="selected"' : '' ) . '>' . esc_html( $value ) . '</option>';
        }
        echo '</select> ';

        if ( ! empty( $field['description'] ) ) {

            if ( isset( $field['desc_tip'] ) && false !== $field['desc_tip'] ) {
                echo '<img class="help_tip" data-tip="' . esc_attr( $field['description'] ) . '" src="' . esc_url( WC()->plugin_url() ) . '/assets/images/help.png" height="16" width="16" />';
            } else {
                echo '<span class="description">' . wp_kses_post( $field['description'] ) . '</span>';
            }

        }
        echo '</p>';    
    }
}
if ( ! function_exists( 'mcmp_get_option_override' ) ) {
    /**
     * Gets option with product option overrides
     * Works with product meta to check for option, if value is empty proceed to general options
     * @param string $option which option to check
     * @param integer $product_id_to_inspect which product to check - supposed to be checked first
     * @param mixed $default value which should be passed if nothing is found
     * @return string
     */
    function mcmp_get_option_override($option, $product_id_to_inspect, $default = '')
    {
        $product_override = $option . '_override';
        $option_val = '';
        //Getting parent product ID of $product_id_to_inspect
        $product_id = mcmp_check_product_id($product_id_to_inspect, true);
        //When the ID differs it means that we deal with variant and that needs extra options
        //Variant options
        if($product_id != $product_id_to_inspect){
            $option_val = get_post_meta($product_id_to_inspect, $product_override, true);
        }
        //Product options
        if (empty($option_val) && is_numeric($product_id)) {
            $option_val = get_post_meta($product_id, $product_override, true);
        }
        //General options
        if (empty($option_val)) {
            $option_val = get_option($option);
        }
        //Everything failed and we have default? Place it there. The ifs order is this because default is rarely used 
        if (!empty($default)) {
            if (empty($option_val)) {
                $option_val = $default;
            }
        }
        return $option_val;
    }
} 
if ( ! function_exists( 'mcmp_check_product_id' ) ) {
    /**
     * Checks if the product is valid and then returns it's ID
     * @param mixed $product_to_inspect which product to check
     * @param boolean $get_parent whether to get parent product ID
     * @return mixed ID of the verified product of false when wrong Product
     */
    function mcmp_check_product_id($product_to_inspect, $get_parent = false)
    {
        $product_id = false;
        if (!empty($product_to_inspect)) {
            if (is_numeric($product_to_inspect)) {
                $product_to_inspect = wc_get_product($product_to_inspect);
            }
            if (is_object($product_to_inspect)) {
                $product_id = $product_to_inspect->get_id();
                if($get_parent == true && $product_to_inspect->get_type() === 'variation'){
                    $product_id =  $product_to_inspect->get_parent_id();
                }
            }
        }
        return $product_id;
    }
}