<?php

/**
* Displays custom settings in WooCommerce backend for product
*
* @package PricePerUnit/Admin
*/

if (!defined('ABSPATH')):
    exit; // Exit if accessed directly
endif;
$product_id=get_the_ID();
$altered_product = wc_get_product($product_id);

//Additional texts
$add_text_opts=get_option('_mcmp_ppu_recalc_text_options');
if(!empty($add_text_opts)){
    $add_text_opts_array=explode('|',$add_text_opts);
    //adding texts as keys
    $add_text_opts_array=array_combine($add_text_opts_array,$add_text_opts_array);
}
$ppu_recalc_text_str = get_option('_mcmp_ppu_recalc_text');
switch ($ppu_recalc_text_str) {
    case ' ':
        $ppu_recalc_text_str = esc_attr__('No suffix text', 'woo-price-per-unit-pro');
        break;
    case '-automatic-':
        $ppu_recalc_text_str = esc_attr__('Automatic text', 'woo-price-per-unit-pro');
        break;
    default:
        $ppu_recalc_text_str = esc_attr_x($ppu_recalc_text_str, 'Recalculated price suffix text' ,'woo-price-per-unit-pro');
        break;
}
$add_text_opts_array[' '] = esc_attr__('No suffix text', 'woo-price-per-unit-pro');
$add_text_opts_array[''] = esc_attr__('Default - according to general settings', 'woo-price-per-unit-pro') .'&nbsp;&nbsp;&nbsp;&nbsp;'. esc_attr__('Currently: ', 'woo-price-per-unit-pro').$ppu_recalc_text_str;
$add_text_opts_array['-custom-'] = esc_attr__('Custom text - enter in textbox below', 'woo-price-per-unit-pro');
$add_text_opts_array['-automatic-'] = esc_attr__('Automatic text - takes unit settings from product', 'woo-price-per-unit-pro');
ksort($add_text_opts_array);
$add_text_curr=get_post_meta($product_id, '_mcmp_ppu_recalc_text_override', true);
$preselected_text='';
if(!empty($add_text_curr)){
    if(array_key_exists($add_text_curr,$add_text_opts_array)==false){
        $preselected_text=$add_text_curr;
        $add_text_curr='-custom-';
    }
}

//Custom units preparation
$cust_unit_opts=get_option('_mcmp_ppu_custom_unit_options');
if(!empty($cust_unit_opts)){
    $cust_unit_opts_array=explode('|',$cust_unit_opts);
    $cust_units_opts_texts= array_map(function($keys){
        $trans = _x( $keys, 'Custom unit name', 'woo-price-per-unit-pro' );
        return ($trans != $keys) ? $trans . ' (before translation: '. $keys . ')' : $keys;
    },$cust_unit_opts_array);
    //adding texts as keys
    $cust_unit_opts_array=array_combine($cust_unit_opts_array,$cust_units_opts_texts);
}
$cust_unit_opts_array[''] = esc_attr__('Default unit - propagated from other settings', 'woo-price-per-unit-pro');
ksort($cust_unit_opts_array);
$cust_unit_curr=get_post_meta($product_id, '_mcmp_ppu_custom_unit_override', true);
if(!empty($cust_unit_curr)){
    if(array_key_exists($cust_unit_curr,$cust_unit_opts_array)==false){
        $trans = _x($cust_unit_curr, 'Custom unit name', 'woo-price-per-unit-pro' );
        $trans = ($trans != $cust_unit_curr) ? $trans . ' (before translation: '. $cust_unit_curr . ')' : $trans;
        $cust_unit_opts_array[$cust_unit_curr] = $trans;
    }
}

//Behavior settings of both pages
$behav_settings = array(
    '' => esc_attr__('Default - according to general settings', 'woo-price-per-unit-pro'),
    'not' => esc_attr__('Do not recalculate', 'woo-price-per-unit-pro'),
    'add' => esc_attr__('Show recalculated price as new row', 'woo-price-per-unit-pro'),
    'replace' => esc_attr__('Replace price view with recalculated', 'woo-price-per-unit-pro'),
);
if($altered_product->get_type()=='variable'){
    $behav_settings['sel_variants'] = esc_attr__('Show new row - for selected variants only', 'woo-price-per-unit-pro');
    $behav_settings['sel_variants_repl'] = esc_attr__('Replace price - for selected variants only', 'woo-price-per-unit-pro');
}

$current_unit = get_option('woocommerce_weight_unit');
echo '<div id="mcmp_ppu_options" class="panel woocommerce_options_panel">';
// mcmp_ppu fields will be created here.
    echo '<p class="admin-warn-no-weight mcmp-product-edit-warn">';
        echo '<span>'.esc_html__('Warning: This product has no weight set. The price per unit will not be shown unless the weight is set on Shipping tab (or in more complicated cases in the field "Custom number of units"). Please check it.', 'woo-price-per-unit-pro');
        echo ' ' . esc_html__('If you use Variable product you can also set weight for each variation separately.', 'woo-price-per-unit-pro') . '</span>';
    echo '</p>';
    echo '<p>';
        echo '<span class="section-heading">' . esc_html__('Local overrides for price recalculation', 'woo-price-per-unit-pro') . '</span></br>';
        echo esc_html__('These settings will affect only this product despite global settings.', 'woo-price-per-unit-pro') . '</br>';
        echo esc_html__('Global settings can be found at ', 'woo-price-per-unit-pro');
        echo '<a href="' . admin_url('admin.php?page=wc-settings&tab=products&section=mcmp_price_pu') . '" target="_blank">';
        echo wp_kses_post(__('<i>WooCommerce -> Settings -> Products -> Price Per Unit</i>', 'woo-price-per-unit-pro')) . '</a>';
    echo '</p>';
    echo '<div class="options_group">';
        woocommerce_wp_select(
            array(
                'id' => '_mcmp_ppu_general_override',
                'label' => esc_html__('Shop page price behavior', 'woo-price-per-unit-pro'),
                'description' => esc_html__('Behaviour of recalculated price on shop page', 'woo-price-per-unit-pro'),
                'default' => '',
                'options' => $behav_settings,
                'desc_tip' => true,
                )
            );
        woocommerce_wp_select(
            array(
                'id' => '_mcmp_ppu_single_page_override',
                'label' => esc_html__('Single product page behavior', 'woo-price-per-unit-pro'),
                'description' => esc_html__('Behaviour of recalculated price on single product page', 'woo-price-per-unit-pro'),
                'default' => '',
                'options' => $behav_settings,
                'desc_tip' => true,
                )
            );
        woocommerce_wp_text_input(
            array(
                'id' => '_mcmp_ppu_recalc_text_prefix_override',
                'label' => esc_html__('Recalculated price prefix text', 'woo-price-per-unit-pro'),
                'description' => esc_html__("Will be shown before the recalculated prices. Can be overriden in product editor. Will be shown ONLY when recalculation takes place. You can modify it's appearance through CSS class mcmp-recalc-price-prefix.", 'woo-price-per-unit-pro'),
                'placeholder' => esc_html__('Example "Unit price:"', 'woo-price-per-unit-pro'),
                'default' => '',
                'desc_tip' => true,
                )
            );
        $ppu_recalc_text = get_option('_mcmp_ppu_recalc_text');
        woocommerce_wp_select(
            array(
                'id' => '_mcmp_ppu_recalc_text_override',
                'label' => esc_html__('Recalculated price suffix text', 'woo-price-per-unit-pro'),
                'description' => esc_html__('Will be shown immediatelly after recalculated prices. Will be shown ONLY when recalculation takes place. If you want more options in this list, you can add them in Global settings of this plugin.', 'woo-price-per-unit-pro'),
                'default' => '',
                'options' => $add_text_opts_array,
                'value' => $add_text_curr,
                'desc_tip' => true,
                'custom_attributes' => array(
                    'data-general-settings' => $ppu_recalc_text,),
                )
            );
        woocommerce_wp_text_input(
            array(
                'id' => '_mcmp_ppu_recalc_text_override_cust',
                'label' => '',
                'description' => esc_html__('Should be used only if you want unique text. For repeated texts it is better to cofigure it in Global settings.', 'woo-price-per-unit-pro'),
                'placeholder' => esc_html__('Enter custom recalculated price suffix text. Example "/piece"', 'woo-price-per-unit-pro'),
                'value' => $preselected_text,
                'desc_tip' => true,
                )
            );

    echo '</div>';
    echo '<div class="options_group">';
        echo '<p>';
            echo '<span class="section-heading">' . esc_html__('Local overrides for general price options', 'woo-price-per-unit-pro') . '</span></br>';
            echo esc_html__('These settings will affect only this product despite global settings.', 'woo-price-per-unit-pro') . '</br>';
            echo esc_html__('This will be visible even if there is no recalculation.', 'woo-price-per-unit-pro');
        echo '</p>';
        woocommerce_wp_text_input(
            array(
                'id' => '_mcmp_ppu_additional_text_override',
                'label' => esc_html__('General price suffix text', 'woo-price-per-unit-pro'),
                'description' => esc_html__("This text will be shown after every price text. You can modify it's appearance through CSS class mcmp-general-price-suffix.", 'woo-price-per-unit-pro'),
                'placeholder' => esc_html__('Example "Without Vat"', 'woo-price-per-unit-pro'),
                'default' => '',
                'desc_tip' => true,
            )
        );
    echo '</div>';
    echo '<div class="options_group">';
        echo '<p>';
            echo '<span class="section-heading">' . esc_html__('Special cases', 'woo-price-per-unit-pro') . ' - ' . esc_html__('Using different unit', 'woo-price-per-unit-pro') . '</span></br>';
            echo esc_html__('These settings will help you when you need to alter the way the recalculation works. Use with caution - it will change the visible price.', 'woo-price-per-unit-pro');
        echo '</p>';
        echo '<p>';
            echo '<span class="field-notes-heading">' . esc_html__('Custom number of units / different weight', 'woo-price-per-unit-pro') . ' - </span>';
                echo esc_html__('Sometimes you may want to use different unit or weight than specified on shipping tab. Here you can enter how much of the product you sell.', 'woo-price-per-unit-pro') . '</br>';
            echo esc_html__('Example 1: You are selling 5 pack of t-shirts and you want to show price for 1 piece(enter 5 here)', 'woo-price-per-unit-pro') . '</br>';
            echo esc_html__('Example 2: You are selling food in some package and you need to have the weight in shipping tab with the package for shipping purposes. But you want to show the proper recalculated price per content weight. Put full weight in shipping tab and enter here the weight of the content alone.', 'woo-price-per-unit-pro');
        echo '</p>';
        woocommerce_wp_select(
            array(
                'id' => '_mcmp_ppu_custom_unit_override',
                'label' => esc_html__('Custom unit name', 'woo-price-per-unit-pro'),
                'description' => esc_html__('Will be shown immediatelly after recalculated prices. Will be shown ONLY when recalculation takes place. If you want more options in this list, you can add them in Global settings of this plugin.', 'woo-price-per-unit-pro'),
                'default' => '',
                'options' => $cust_unit_opts_array,
                'desc_tip' => true,
                )
            );
        echo '<p class="admin-warn-cust-unit-name-not-effective mcmp-product-edit-warn">';
            echo '<span >' . esc_html__('Warning: "Custom unit name" works only when "Recalculated price suffix text" is set to Automatic text.', 'woo-price-per-unit-pro') . '</span>';
        echo '</p>';
        woocommerce_wp_text_input(
            array(
                'id' => '_mcmp_ppu_cust_num_of_units_override',
                'label' => esc_html__('Custom number of units', 'woo-price-per-unit-pro'),
            'description' => esc_html__("If you don't want to use this delete the value or set it to 0", 'woo-price-per-unit-pro'),
            'placeholder' => esc_html__('Enter number of units in decimal form - default is 0 or empty', 'woo-price-per-unit-pro'),
            'default' => '',
            'type' => 'text',
            'data_type' => 'decimal',
            'desc_tip' => true,
            )
        );
        echo '<p class="admin-warn-cust-units mcmp-product-edit-warn">';
            echo '<span >'.sprintf(esc_html__('Warning: "Custom number of units", is still related to original units (currently %s). So if you have shop in kg, and you enter there 5 and change unit to g the price will be recalculted per 5 kg not grams.', 'woo-price-per-unit-pro'), esc_html__($current_unit, 'woocommerce')) . '</span>';
        echo '</p>';
        echo '<p>';
            echo '<span class="field-notes-heading">' . esc_html__('Different weight unit', 'woo-price-per-unit-pro') . ' - </span>';
                echo esc_html__("The case scenario is that your shop is set to sell in Kg, but for some products you want show the price for Grams instead. Doesn't change the weight into selected unit - only shows how much the selected unit costs", 'woo-price-per-unit-pro');
        echo '</p>';
        woocommerce_wp_select(
            array(
                'id' => '_mcmp_ppu_ratio_unit_override',
                'label' => esc_html__('Different weight unit', 'woo-price-per-unit-pro'),
                'description' => sprintf(esc_html__('Recalculate price per this unit. Current shop unit is "%s"', 'woo-price-per-unit-pro'), esc_html__($current_unit, 'woocommerce')),
                'default' => '',
                'options' => array(
                    '' => esc_attr__('Shop default', 'woo-price-per-unit-pro'),
                    //TRANSLATORS:Weight unit shown on front with Automatic text
                    'kg' => esc_attr(_nx( 'kg', 'kg', 1,'weight unit', 'woo-price-per-unit-pro')),
                    //TRANSLATORS:Weight unit shown on front with Automatic text
                    'g' => esc_attr(_nx( 'g', 'g', 1,'weight unit', 'woo-price-per-unit-pro')),
                    //TRANSLATORS:Weight unit shown on front with Automatic text
                    'lbs' => esc_attr(_nx( 'lb', 'lbs', 2,'weight unit', 'woo-price-per-unit-pro')),
                    //TRANSLATORS:Weight unit shown on front with Automatic text
                    'oz' => esc_attr(_nx( 'oz', 'oz', 1,'weight unit', 'woo-price-per-unit-pro'))),
                'desc_tip' => false,
            )
        );
        echo '<p>';
            echo '<span class="field-notes-heading">' . esc_html__('Recalculate per units - multiplication ratio', 'woo-price-per-unit-pro') . ' - </span>';
                echo esc_html__('The recalculation works with one weight unit (kg,g,oz,...) here you can set different number of units for recalculation - i.e. to display price for 100 grams (If your shop is in Kg enter 0.1 for 100 grams).', 'woo-price-per-unit-pro');
                echo ' '. esc_html__('The unit price is then multiplied with this number.', 'woo-price-per-unit-pro');
        echo '</p>';
        woocommerce_wp_text_input(
            array(
                'id' => '_mcmp_ppu_recalc_per_units_override',
                'label' => esc_html__('Recalculate per units - multiplication ratio', 'woo-price-per-unit-pro'),
                'description' => esc_html__("Default is 1. If you don't want to use this delete the value or set it to 1", 'woo-price-per-unit-pro'),
                'placeholder' => esc_html__('Enter number in decimal form - default is 1 or empty', 'woo-price-per-unit-pro'),
                'default' => '1',
                'type' => 'text',
                'data_type' => 'decimal',
                'desc_tip' => true,
            )
        );
    echo '</div>';
echo '</div>';