<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package tm-organik
 */
?>
    <!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
		<meta name="google-site-verification" content="51cJUuzvbjyn_oE_aREHfRvFwZxIJiORlt5etHY7wmY" />
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1"/>
        <link rel="profile" href="http://gmpg.org/xfn/11">
		<link rel="apple-touch-icon" sizes="120x120" href="/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
<link rel="manifest" href="/site.webmanifest">
<link rel="mask-icon" href="/safari-pinned-tab.svg" color="#5bbad5">
<meta name="msapplication-TileColor" content="#00a300">
<meta name="theme-color" content="#ffffff">
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
            <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php endif; ?>
		<?php wp_head(); ?>
    </head>

<body <?php body_class(); ?>>

<?php wp_body_open(); ?>

<?php get_template_part( 'components/mobile-menu' ); ?>

<div id="page" class="site">
<?php Insight::slider( 'above' ) ?>
<?php get_template_part( 'components/' . Insight::setting( 'header_type' ) ); ?>
<?php get_template_part( 'components/header-mobile' ); ?>
    <div id="content" class="content">
<?php Insight::slider( 'below' ) ?>