<?php

/**
* Plugin checkers - functions made public to allow checking active plugins.
*
* @package PricePerUnit/Admin
*/

if (!defined('ABSPATH')):
    exit; // Exit if accessed directly
endif;

if ( ! function_exists( 'mcmp_is_wcpt_active' ) ) {
    /**
	 * Checks if WCPT is active
	 *
	 * @return boolean
	 * @since 2.1.0
	 */
	function mcmp_is_wcpt_active() {
		$plugin = 'wc-product-table-pro/main.php';
		if ( in_array( $plugin, (array) get_option( 'active_plugins' ), true ) || ( is_multisite() && array_key_exists( $plugin, 'active_plugins', (array) get_site_option( 'active_sitewide_plugins' ) ) ) ) {
			return true;
		}
		return false;
	}
}
if ( ! function_exists( 'mcmp_is_yith_dyn_pr_active' ) ) {
    /**
	 * Checks if YITH WooCommerce Dynamic Pricing and Discounts Premium is active
	 *
	 * @return boolean
	 * @since 2.1.0
	 */
	function mcmp_is_yith_dyn_pr_active() {
		$plugin = 'yith-woocommerce-dynamic-pricing-and-discounts-premium/init.php';
		if ( in_array( $plugin, (array) get_option( 'active_plugins' ), true ) || ( is_multisite() && array_key_exists( $plugin, 'active_plugins', (array) get_site_option( 'active_sitewide_plugins' ) ) ) ) {
			return true;
		}
		return false;
	}
}
if ( ! function_exists( 'mcmp_is_wpml_active' ) ) {
		/**
		 * Checks if WPML is active
		 *
		 * @return boolean
		 * @since 2.1.2
		 */
		function mcmp_is_wpml_active() {
			$plugin = 'wpml-string-translation/plugin.php';
			if ( in_array( $plugin, (array) get_option( 'active_plugins' ), true ) || ( is_multisite() && array_key_exists( $plugin, 'active_plugins', (array) get_site_option( 'active_sitewide_plugins' ) ) ) ) {
				return true;
			}
			return false;
		}
}
