<?php
/**
* Displays custom settings in WooCommerce general settings under product - Price per unit
*
* @package PricePerUnit/Admin
* @return array Settings for new tab in WooCommerce settings
*/

if (!defined('ABSPATH')):
    exit; // Exit if accessed directly
endif;

$add_text_opts=get_option('_mcmp_ppu_recalc_text_options');
if(!empty($add_text_opts)){
    $add_text_opts_array=explode('|',$add_text_opts);
    foreach($add_text_opts_array as $key => $value)
    {
        $add_text_opts_array[$key] = esc_attr($value);
    }
    //adding texts as keys
    $add_text_opts_array=array_combine($add_text_opts_array,$add_text_opts_array);
}
$add_text_opts_array[' '] = esc_attr__('No suffix text', 'woo-price-per-unit-pro');
$add_text_opts_array['-automatic-'] = esc_attr__('Automatic text - takes unit settings from product', 'woo-price-per-unit-pro');
$add_text_curr=get_option('_mcmp_ppu_recalc_text');
$add_text_curr=(empty($add_text_curr)) ? ' ' : $add_text_curr;
if(array_key_exists($add_text_curr,$add_text_opts_array)==false){
    $add_text_opts_array[$add_text_curr] = esc_attr($add_text_curr);
}

ksort($add_text_opts_array);
$custom_settings = array(
    array(
        'id' => 'mcmp_general_options',
        'name' => esc_html__('General price options', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('Settings which affects all products', 'woo-price-per-unit-pro'),
        'type' => 'title',
    ),
    array(
        'id' => '_mcmp_ppu_additional_text',
        'name' => esc_html__('General price suffix text', 'woo-price-per-unit-pro'),
        'desc' => esc_html__("This text will be shown after every price text. You can modify it's appearance through CSS class mcmp-general-price-suffix.", 'woo-price-per-unit-pro'),
        'placeholder' => esc_html__('Example "Without Vat"', 'woo-price-per-unit-pro'),
        'type' => 'text',
        'default' => '',
    ),
    array(
        'id' => '_mcmp_ppu_hide_sale_price',
        'name' => esc_html__('Sale price - hide regular price', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('When product is on sale it shows regular price and sale price. This will hide the regular price for all products.', 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'no',
        'desc_tip' => false,
    ),
    array('type' => 'sectionend', 'id' => 'mcmp_general_options'),
    array(
        'id' => 'mcmp_variable_options',
        'name' => esc_html__('Options for variable products', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('These settings affect only variable products', 'woo-price-per-unit-pro'),
        'type' => 'title',
    ),
    array(
        'id' => '_mcmp_ppu_var_prefix_text',
        'name' => esc_html__('Variations - variable price prefix', 'woo-price-per-unit-pro'),
        'desc' => esc_html__("If the product is variable this text will be shown before the price. You can modify it's appearance through CSS class mcmp-variable-price-prefix.", 'woo-price-per-unit-pro'),
        'placeholder' => esc_html__('Example "From:"', 'woo-price-per-unit-pro'),
        'type' => 'text',
        'default' => '',
        'disabled' => true,
    ),
    array(
        'id' => '_mcmp_ppu_var_hide_max_price',
        'name' => esc_html__('Variations - Display only lower price', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('When displaying variation the price is displayed as "$10-$25". With this setting you will get just "$10"', 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'no',
        'desc_tip' => false,
	),
    array(
        'id' => '_mcmp_ppu_var_show_sale_price',
        'name' => esc_html__('Variations - Show regular price', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('Mimics pre WooCommerce 3 variable product price display - Shows how much was the cost before sale', 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'no',
        'desc_tip' => false,
	),
	array('type' => 'sectionend', 'id' => 'mcmp_variable_options'),
	array(
        'id' => 'mcmp_variable_recalc_options',
        'name' => esc_html__('Options for recalculation on variable products', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('These settings affect only recalculated variable products', 'woo-price-per-unit-pro'),
        'type' => 'title',
    ),
    array(
        'id' => '_mcmp_ppu_var_display_option_recalc',
        'name' => esc_html__('Variations - display recalculated price on option', 'woo-price-per-unit-pro'),
        'desc' => esc_html__("Display recalculated price as new row after selected variant price on single product page. Doesn't show if recalculation is off for the product", 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'no',
        'desc_tip' => false,
    ),
    array(
		'id' => '_mcmp_ppu_var_display_option_recalc_forced',
        'name' => '',
        'desc' => esc_html__("Force display this feature even when recalculation is off for the product", 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'no',
        'desc_tip' => false,
    ),
	array(
		'id' => '_mcmp_ppu_var_option_add_gen_suff_texts',
		'name' => esc_html__("Add 'General price suffix text' to the option price", 'woo-price-per-unit-pro'),
		'desc' => esc_html__("When the recalculation for selected variant price is on, this will add the 'General price suffix text' the the option price.", 'woo-price-per-unit-pro'),
		'type' => 'checkbox',
		'default' => 'no',
		'desc_tip' => false,
	),
	array(
		'id' => '_mcmp_ppu_var_display_corresp_recalc_prices',
		'name' => esc_html__('Variations - display corresponding recalculated prices', 'woo-price-per-unit-pro'),
		'desc' => esc_html__("Normally when the plugin calculates prices for Variable product it displays the PPU price lowest to highest - without regard to the original price.", 'woo-price-per-unit-pro')
			.esc_html__("This setting will display corresponding PPU price to the minimal and maximal price.")
			.'</br><i>'.esc_html__("Example: T-shirt 2 pieces pack costs 10 USD (PPU - 5USD), 5 pieces pack costs 15 USD (PPU - 3USD). Normal display of price 10-15USD(3-5USD/piece). With this setting on the displayed price will be 10-15USD(5-3USD/piece).").'</i>',
		'type' => 'checkbox',
		'default' => 'no',
		'desc_tip' => false,
	),
    array('type' => 'sectionend', 'id' => 'mcmp_recalc_variable_options'),
    array(
        'id' => 'mcmp_recalculation_options',
        'name' => esc_html__('Price recalculation', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('General settings for price recalculation', 'woo-price-per-unit-pro'),
        'type' => 'title',
    ),
    array(
        'id' => '_mcmp_ppu_add_row_css',
        'name' => esc_html__('New row different styling', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('When displaying price as new row, the new row will be displayed in italics with slightly smaller font size. For more styling you can use CSS class mcmp_recalc_price_row.', 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'no',
        'desc_tip' => false,
    ),
    array(
        'id' => '_mcmp_ppu_general',
        'name' => esc_html__('Shop page price behavior', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('Behaviour of recalculated price on shop page', 'woo-price-per-unit-pro'),
        'css' => '',
        'class' => 'wc-enhanced-select',
        'type' => 'select',
        'default' => 'add',
        'options' => array(
            'not' => esc_attr__('Do not show recalculated price', 'woo-price-per-unit-pro'),
            'add' => esc_attr__('Show recalculated price as new row', 'woo-price-per-unit-pro'),
            'replace' => esc_attr__('Replace price view with recalculated', 'woo-price-per-unit-pro'),
        ),
        'desc_tip' => false,
    ),
    array(
        'id' => '_mcmp_ppu_single_page',
        'name' => esc_html__('Single product page behavior', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('Behaviour of recalculated price on single product page', 'woo-price-per-unit-pro'),
        'css' => '',
        'class' => 'wc-enhanced-select',
        'type' => 'select',
        'default' => 'add',
        'options' => array(
            'not' => esc_attr__('Do not show recalculated price', 'woo-price-per-unit-pro'),
            'add' => esc_attr__('Show recalculated price as new row', 'woo-price-per-unit-pro'),
            'replace' => esc_attr__('Replace price view with recalculated', 'woo-price-per-unit-pro'),
        ),
        'desc_tip' => false,
    ),
    array(
        'id' => '_mcmp_ppu_cart_page',
        'name' => esc_html__('Cart page behavior', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('Behaviour of recalculated price on cart page.', 'woo-price-per-unit-pro'),
        'css' => '',
        'class' => 'wc-enhanced-select',
        'type' => 'select',
        'default' => 'replace',
        'options' => array(
            'not' => esc_attr__('Do not show recalculated price', 'woo-price-per-unit-pro'),
            'add' => esc_attr__('Show recalculated price always - new row', 'woo-price-per-unit-pro'),
            'replace' => esc_attr__('Show recalculated price always - replace original', 'woo-price-per-unit-pro'),
            '_mcmp_ppu_single_page-add' => esc_attr__('Show if displayed on Single product page - new row', 'woo-price-per-unit-pro'),
            '_mcmp_ppu_single_page-replace' => esc_attr__('Show if displayed on Single product page - replace original', 'woo-price-per-unit-pro'),
            '_mcmp_ppu_general-add' => esc_attr__('Show if displayed on Shop page - new row', 'woo-price-per-unit-pro'),
            '_mcmp_ppu_general-replace' => esc_attr__('Show if displayed on Shop page - replace original', 'woo-price-per-unit-pro'),

        ),
        'desc_tip' => false,
	),
	array(
        'id' => '_mcmp_ppu_cart_show_sale_price',
        'name' => esc_html__('Cart - Sale products - show regular price', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('Show recalculated regular price in Cart. Up to version 2.0.9 it was displayed by default, but WooCommerce stopped displaying regular price, so do we.', 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'no',
        'desc_tip' => false,
    ),
	array(
        'id' => '_mcmp_ppu_orders_ppu_show',
        'name' => esc_html__('Show PPU price in Orders', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('This will add new column in Order details which will display Price per Unit.', 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'no',
        'desc_tip' => false,
    ),
    array(
        'id' => '_mcmp_ppu_recalc_text_prefix',
        'name' => esc_html__('Recalculated price prefix text', 'woo-price-per-unit-pro'),
        'desc' => esc_html__("Will be shown before the recalculated prices. Can be overriden in product editor. Will be shown ONLY when recalculation takes place. You can modify it's appearance through CSS class mcmp-recalc-price-prefix.", 'woo-price-per-unit-pro'),
        'type' => 'text',
        'placeholder' => esc_html__('Example "Unit price:"', 'woo-price-per-unit-pro'),
        'default' => '',
    ),
    array(
        'id' => '_mcmp_ppu_recalc_text',
        'name' => esc_html__('Recalculated price suffix text', 'woo-price-per-unit-pro'),
        'desc' => esc_html__("Will be shown immediatelly after recalculated prices. Can be overriden in product editor. Will be shown ONLY when recalculation takes place. You can modify it's appearance through CSS class mcmp-recalc-price-suffix.", 'woo-price-per-unit-pro'),
        'css' => '',
        'class' => 'wc-enhanced-select',
        'type' => 'select',
        'default' => '-automatic-',
        'options' => $add_text_opts_array,
        'desc_tip' => false,
    ),
    array(
        'id' => '_mcmp_ppu_recalc_text_automatic_preposition',
        'name' => esc_html__('Preposition for weight unit when using automatic text', 'woo-price-per-unit-pro'),
        'desc' => esc_html__("Automatic text will create text like this '$10/kg' with this option you can replace '/' sign with what you want.", 'woo-price-per-unit-pro').' '.esc_html__('To add space replace it with "%" sign.', 'woo-price-per-unit-pro'),
        'type' => 'text',
        'placeholder' => esc_html__('Example "/" or "per%".', 'woo-price-per-unit-pro').' '.esc_html__('To add space replace it with "%" sign.', 'woo-price-per-unit-pro'),
        'default' => '/',
    ),
    array(
        'id' => '_mcmp_ppu_custom_unit_options',
        'name' => esc_html__('Predefined custom units names - used with automatic text', 'woo-price-per-unit-pro'),
        'desc' => esc_html__("Set of custom units to be used with automatic text. When using different unit from default WooCommerce weight units (piece, box,...) you can select it then in Single product editor. Multiple values can be separated with '|' sign.", 'woo-price-per-unit-pro'),
        'placeholder' => esc_html__('Example "piece"', 'woo-price-per-unit-pro'),
        'type' => 'text',
        'default' => 'box|bunch|litre|pack|pair|piece',
    ),
    array(
        'id' => '_mcmp_ppu_recalc_text_options',
        'name' => esc_html__('Predefined Recalculated price suffix text values - obstolete better to use "custom units" setting above', 'woo-price-per-unit-pro'),
        'desc' => esc_html__("Set of suffix texts from which you will be able to choose on product page. Multiple values can be separated with '|' sign.", 'woo-price-per-unit-pro'),
        'placeholder' => esc_html__('Example "/pair"', 'woo-price-per-unit-pro'),
        'type' => 'text',
        'default' => '/pair|/bunch',
    ),
    array(
        'id' => '_mcmp_ppu_recalc_text_separate',
        'name' => esc_html__('Separate text from price with space', 'woo-price-per-unit-pro'),
        'desc' => esc_html__("The suffix text is normally separated from the recalculated price with unbreakable space. If you don't want it uncheck this option.", 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'yes',
        'desc_tip' => false,
    ),
    array(
        'id' => '_mcmp_ppu_disable_price_rounding',
        'name' => __('Disable price rounding', 'woo-price-per-unit-pro'),
        'desc' => __('Normally WooCommerce rounds displayed prices - if you want recalculated prices trimmed instead check this field.', 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'no',
        'desc_tip' => false,
    ),
    array(
        'id' => '_mcmp_ppu_display_additional_info',
        'name' => __('Display modified units info on product details', 'woo-price-per-unit-pro'),
        'desc' => __('When you modify units on the product (select different unit or set Custom number of units), the info will be displayed in "Additional information" on product details.', 'woo-price-per-unit-pro'),
        'type' => 'checkbox',
        'default' => 'yes',
        'desc_tip' => false,
    ),
    array('type' => 'sectionend', 'id' => 'mcmp_recalculation_options'),
    array(
        'id' => 'mcmp_special_cases',
        'name' => esc_html__('Special cases', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('These settings will help you when you need to alter the way the recalculation works. Use with caution - it will change the visible price.', 'woo-price-per-unit-pro'),
        'type' => 'title',
    ),
    array(
        'id' => '_mcmp_ppu_recalc_per_units',
        'name' => esc_html__('Recalculate per units - multiplication ratio', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('The recalculation works with one weight unit (kg,g,oz,...) here you can set different number of units for recalculation - i.e. to display price for 100 grams.', 'woo-price-per-unit-pro')
            .' '. esc_html__('The unit price is then multiplied with this number.', 'woo-price-per-unit-pro'),
        'placeholder' => esc_html__('Enter number of units in decimal form - default is 1 or empty', 'woo-price-per-unit-pro'),
        'type' => 'text',
        'class' => 'mcmp_ppu_custom_ratio_field',
        'default' => '1',
        'desc_tip' => false,
    ),
	array('type' => 'sectionend', 'id' => 'mcmp_special_cases'),
    array(
        'id' => 'mcmp_fine_tuning_options',
        'name' => esc_html__('Plug-in tuning', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('These settings are dedicated some fine tuning of the plug-in.', 'woo-price-per-unit-pro'),
        'type' => 'title',
	),
	array(
        'id' => '_mcmp_ppu_element_classes',
        'name' => esc_html__('PPU elements CSS classes', 'woo-price-per-unit-pro'),
        'desc' => esc_html__("Every PPU text element has it's own CSS class. In addition there are default WooCommerce CSS classes. Here you can remove or replace them.", 'woo-price-per-unit-pro'),
        'placeholder' => esc_html__('Default: woocommerce-Price-currencySymbol amount', 'woo-price-per-unit-pro'),
        'type' => 'text',
        'default' => 'woocommerce-Price-currencySymbol amount',
    ),
	array('type' => 'sectionend', 'id' => 'mcmp_fine_tuning_options'),
    array(
        'id' => 'mcmp_databse_options',
        'name' => esc_html__('Database options', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('These settings are related to the plugin database and its maintenance.', 'woo-price-per-unit-pro'),
        'type' => 'title',
	),
	array(
		'id' => '_mcmp_ppu_use_price_meta',
		'name' => esc_html__('Save price meta in database', 'woo-price-per-unit-pro'),
		'desc' => esc_html__('The plugin will save PPU prices into the database. It can be used for product sorting.', 'woo-price-per-unit-pro')
			.' '. esc_html__('After enabling this feature, you will need to press the button "Re-create prices" for initializing PPU price data.', 'woo-price-per-unit-pro')
			.'</br>'. esc_html__('This feature is experimental - the data are created during save - it may not work properly with some bulk product editors.', 'woo-price-per-unit-pro'),
		'type'        => 'checkbox',
		'default'    => 'no',
		'desc_tip'    => false
	),
	array(
		'id' => '_mcmp_ppu_add_ppu_orderby',
		'name' => esc_html__('Add PPU price sorting', 'woo-price-per-unit-pro'),
		'desc' => esc_html__('Adds "Sort by Price per unit" among products sorting. Products without PPU price are treated as if the PPU price is equal to zero', 'woo-price-per-unit-pro'),
		'class' => 'mcmp-price-meta-related',
		'type'        => 'checkbox',
		'default'    => 'no',
		'desc_tip'    => false
	),
    array(
        'id'	=> 'mcmp_ppu_recreate_ppu_prices',
        'name' => esc_html__('Re-create saved recalc prices', 'woo-price-per-unit-pro'),
        'type' => 'mcmp_ppu_button',
        'class' => 'button-primary mcmp-price-meta-related',
        'button_type' => 'button',
        'button_text' => esc_html__('Re-create prices','woo-price-per-unit-pro'),
        'desc' => esc_html__('Calculates prices for all enabled products and stores it in meta for specific use.','woo-price-per-unit-pro')
            .' '. esc_html__('Meta names: _mcmp_ppu_price, _mcmp_ppu_price_text.', 'woo-price-per-unit-pro'),
        'desc_tip' => false,
    ),
    array(
        'id' => '_mcmp_ppu_display_product_cols',
        'name' => esc_html__('Display DB recalculated meta in products list', 'woo-price-per-unit-pro'),
		'desc' => esc_html__('When checked you will see recalculated product texts in Products as a new column. Intended just for a check.', 'woo-price-per-unit-pro'),
		'class' => 'mcmp-price-meta-related',
        'type'        => 'checkbox',
        'default'    => 'no',
        'desc_tip'    => false
    ),
    array('type' => 'sectionend', 'id' => 'mcmp_databse_options'),
	array(
		'id'   => 'mcmp_ppu_wpml_options',
		'name' => esc_html__( 'WPML options', 'woo-price-per-unit-pro' ),
		'desc' => esc_html__( 'These settings are related to WPML - WordPress MultiLingual plugin.', 'woo-price-per-unit-pro' ),
		'type' => 'title',
	),
	array(
        'id'	=> 'mcmp_ppu_wpml_strings_maintenance',
        'name' => esc_html__('Run WPML strings maintenance', 'woo-price-per-unit-pro'),
        'type' => 'mcmp_ppu_button',
        'class' => 'button-primary',
        'button_type' => 'button',
        'button_text' => esc_html__('WPML maintenance','woo-price-per-unit-pro'),
		'desc' => esc_html__("Registers Strings from 'Predefined custom units names' and 'Predefined Recalculated price suffix text values' as WPML strings.",'woo-price-per-unit-pro')
			.'</br>'. esc_html__("Can be used if you're using this plugin and you have just installed WPML.",'woo-price-per-unit-pro'),
		'custom_attributes' => \mcmp_is_wpml_active() ? '' :
			array(
				'disabled' => '',
			),
        'desc_tip' => false,
    ),
	array(
		'type' => 'sectionend',
		'id'   => 'mcmp_ppu_wpml_options',
	),
    array(
        'id' => 'mcmp_plugin_options',
        'name' => esc_html__('Maintenance', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('These settings are related just to the plugin itself.', 'woo-price-per-unit-pro'),
        'type' => 'title',
    ),
    array(
        'id' => '_mcmp_ppu_hook_priority',
        'name' => esc_html__('Priority of price display processing', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('When price display is not working properly, you can adjust the priority to higher number for later execution, to run after other plug-ins. Default is 1010.', 'woo-price-per-unit-pro'),
        'type'      => 'number',
        'default'   => 1010,
        'custom_attributes' =>array(
            'min'       =>  1,
            'max'       =>  10000000,
        ),
        'desc_tip'  => false
    ),
    array(
        'id' => '_mcmp_ppu_delete_meta',
        'name' => esc_html__('Delete settings on uninstall', 'woo-price-per-unit-pro'),
        'desc' => esc_html__('With this setting you will delete all plugin settings on uninstallation.', 'woo-price-per-unit-pro'),
        'type'        => 'checkbox',
        'default'    => 'no',
        'desc_tip'    => false
    ),
    array('type' => 'sectionend', 'id' => 'mcmp_plugin_options'),
);
return $custom_settings;