/*
*   Javacripts for Product page
*/
"use strict";
//Hides or shows custom field on product page if select "Recalculated price additional text" is set to Custom
jQuery(document).ready(function($){
    var selectAddRecalcText = $( 'select#_mcmp_ppu_recalc_text_override' );
    var inputRecalcTextOvr = $('p._mcmp_ppu_recalc_text_override_cust_field');
    EnableCustomRecalcTextOvr();
    selectAddRecalcText.on( "change", function(){EnableCustomRecalcTextOvr(300)});
    function EnableCustomRecalcTextOvr(speed=0) {
        if ( selectAddRecalcText.prop("value")=='-custom-' ) {
            inputRecalcTextOvr.show(speed);
        } else {
            inputRecalcTextOvr.hide(speed);
        }
    }
});
//Shows a warning if "Custom number of units" not empty and "Different weight unit" is set to some different unit
jQuery(document).ready(function($){
    var selectDifWeight = $( 'select#_mcmp_ppu_ratio_unit_override' );
    var inputCustNumOfUnits = $( 'input#_mcmp_ppu_cust_num_of_units_override' );
    ShowDiffWeight();
    selectDifWeight.on( "change", function(){ShowDiffWeight()});
    inputCustNumOfUnits.on( "change", function(){ShowDiffWeight()});
    function ShowDiffWeight() {
        if ( selectDifWeight.val() != "" && inputCustNumOfUnits.val() !="") {
            $( ".admin-warn-cust-units" ).show();
        } else {
            $( ".admin-warn-cust-units" ).hide();
        }
    }
});
//Shows a warning if "Custom unit name" is selected, but "Recalculated price suffix text" is not set to automatic
jQuery(document).ready(function($){
    var selectRecalcTextOvr = $( 'select#_mcmp_ppu_recalc_text_override' );
    var selectCustomUnit = $( 'select#_mcmp_ppu_custom_unit_override' );
    var selectRecalcTextGeneral = selectRecalcTextOvr.data('general-settings');
    ShowUnitNameWarn();
    selectRecalcTextOvr.on( "change", function(){ShowUnitNameWarn()});
    selectCustomUnit.on( "change", function(){ShowUnitNameWarn()});
    function ShowUnitNameWarn() {
        var selectedRecalcVal = selectRecalcTextOvr.val();
        if (selectCustomUnit.val() != '' && !(selectedRecalcVal == '-automatic-' || (selectedRecalcVal == '' && selectRecalcTextGeneral == '-automatic-')))
        {
            $( ".admin-warn-cust-unit-name-not-effective" ).show();
        } else {
            $( ".admin-warn-cust-unit-name-not-effective" ).hide();
        }
    }
});
//Warning for no weight set
jQuery(document).ready(function($){
    var inputWeight = $( '#shipping_product_data input#_weight' );
    var inputCustNumOfUnits = $( 'input#_mcmp_ppu_cust_num_of_units_override' );
    ShowNoWeightWarn();
    inputWeight.on( "change", function(){ShowNoWeightWarn()});
    inputCustNumOfUnits.on( "change", function(){ShowNoWeightWarn()});
    function ShowNoWeightWarn() {
        if ( inputWeight.val() == "" && inputCustNumOfUnits.val() == "") {
            $( ".admin-warn-no-weight" ).show();
        } else {
            $( ".admin-warn-no-weight" ).hide();
        }
    }
});
/*
*   Javacripts for General settings page
*/
jQuery(document).ready(function($){
	//Hides or shows "Preposition for weight" on general settings if select "Recalculated price additional text" is set to Automatic
    var selectRecalcText = $( 'select#_mcmp_ppu_recalc_text' );
    var inputRecalcPreposition = $( 'input#_mcmp_ppu_recalc_text_automatic_preposition' ).closest('tr');
    ShowPreposition();
    selectRecalcText.on( "change", function(){ShowPreposition(300)});
    function ShowPreposition(speed=0) {
        if ( selectRecalcText.val()=='-automatic-' ) {
            inputRecalcPreposition.show(speed);
        } else {
            inputRecalcPreposition.hide(speed);
        }
	}

	//Enables/disables controls related to meta in Database
    var checkboxUsePriceMeta = $( 'input#_mcmp_ppu_use_price_meta' );
    var optionsMetaRelated = $('.mcmp-price-meta-related');
    DisablePriceMetaOpts();
    checkboxUsePriceMeta.on( "change", function(){DisablePriceMetaOpts()});
    function DisablePriceMetaOpts() {
		if ( checkboxUsePriceMeta.prop("checked") == true ) {
            optionsMetaRelated.prop("disabled",false);
        } else {
            optionsMetaRelated.prop("disabled",true);
        }
	}
	
	//Disables form checking when clicking Activate/Deactivate licence
	$( 'button#mcmp_ppu_licence_activate,button#mcmp_ppu_licence_deactivate' ).on( "click", function() {
		window.onbeforeunload="";
	});
	
});