<?php
/**
 * Show cache modules and allow users to clear cache for selected ones.
 *
 * @package Hummingbird
 *
 * @since 2.7.1
 */

use Hummingbird\Core\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$modules = apply_filters( 'wphb_active_cache_modules', Utils::get_active_cache_modules() );

$mod_descriptions = array(
	'page_cache' => __( 'Clear the static HTML copies of your pages and posts.', 'wphb' ),
	'minify'     => __( 'Clear all cached assets from the Asset Optimization module.', 'wphb' ),
	'gravatar'   => __( 'Target all locally cached Gravatars.', 'wphb' ),
	'redis'      => __( 'Discard any object cache that has been generated by Redis.', 'wphb' ),
	'varnish'    => __( 'Include Varnish Cache to remove the site cache.', 'wphb' ),
	'opcache'    => __( 'By selecting OpCache, you will clear the bytecode cache.', 'wphb' ),
);
?>

<div class="sui-modal sui-modal-md">
	<div
		role="dialog"
		id="clear-cache-modal"
		class="sui-modal-content"
		aria-live="polite"
		aria-modal="true"
		aria-labelledby="clear-cache-modal-title"
		aria-describedby="clear-cache-modal-description"
	>
		<div class="sui-box">
			<div class="sui-box-header">
				<button type="button" class="sui-button-icon sui-button-float--right" data-modal-close>
					<span class="sui-icon-close sui-md" aria-hidden="true"></span>
					<span class="sui-screen-reader-text">
						<?php esc_html_e( 'Close this dialog window', 'wphb' ); ?>
					</span>
				</button>
				<h3 class="sui-box-title" id="clear-cache-modal-title">
					<?php esc_html_e( 'Clear Cache', 'wphb' ); ?>
				</h3>
			</div>

			<div class="sui-box-body">
				<p class="sui-description" id="clear-cache-modal-description">
					<?php esc_html_e( 'Choose which cache type you want to clear. We listed the active cache types below.', 'wphb' ); ?>
				</p>

				<?php foreach ( $modules as $mod_id => $name ) : ?>
					<label for="<?php echo esc_attr( $mod_id ); ?>" class="sui-checkbox sui-checkbox-stacked">
						<input type="checkbox" id="<?php echo esc_attr( $mod_id ); ?>" data-module="<?php echo esc_attr( $mod_id ); ?>" checked="checked">
						<span aria-hidden="true"></span>
						<span class="sui-description sui-description-sm">
							<?php echo esc_html( $name ); ?>
						</span>
					</label>
					<?php if ( isset( $mod_descriptions[ $mod_id ] ) ) : ?>
						<span class="sui-checkbox-description sui-description">
							<?php echo esc_html( $mod_descriptions[ $mod_id ] ); ?>
						</span>
					<?php endif; ?>
				<?php endforeach; ?>
			</div>

			<div class="sui-box-footer sui-content-separated">
				<button type="button" class="sui-button sui-button-ghost" data-modal-close>
					<?php esc_html_e( 'Cancel', 'wphb' ); ?>
				</button>

				<button type="button" class="sui-button sui-button-blue" aria-live="polite" id="clear-cache-modal-button">
					<span class="sui-button-text-default">
						<?php esc_html_e( 'Clear now', 'wphb' ); ?>
					</span>
					<span class="sui-button-text-onload">
						<span class="sui-icon-loader sui-loading" aria-hidden="true"></span>
						<?php esc_html_e( 'Clearing', 'wphb' ); ?>
					</span>
				</button>
			</div>
		</div>
	</div>
</div>
