<?php

namespace PPU\Helpers;

if (! defined('ABSPATH') ) :
    exit; // Exit if accessed directly.
endif;
/* 
 * Class containing functions regarding plug-ins integration
 * Plug-in YITH WooCommerce Dynamic Pricing and Discounts Premium
 */
if (!class_exists('PPU\Helpers\YITH_Dyn_Pr_Helper') ) {
    class YITH_Dyn_Pr_Helper
    {

		public $hook_priority = 1010;
		public $yith_frontend_obj = null;
        /**
         * Class instance 
         */
        private static $_instance = null;

        /**
         * Returns instance of the class.
         *
         * @since 2.1.0
         */
        public static function get_instance()
        {
            if (null == self::$_instance ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        /**
         * The Constructor!
         *
         * @since 2.1.0
         */
        public function __construct()
        {
            $hook_priority = intval(get_option('_mcmp_ppu_hook_priority'));
            if(!empty($hook_priority)) {
                $this->hook_priority = $hook_priority;
			}
			add_action( 'yith_ywdpd_init', array($this,'load_yith_classes'), 20 );
            add_filter('mcmp_ppu_cart_regular_price_after_tax', array($this, 'get_yith_cart_regular_price'), $this->hook_priority, 3);
            add_filter('mcmp_ppu_simple_sale_price_before_tax', array($this, 'get_yith_product_min_sale_price'), $this->hook_priority, 2);
			add_filter('mcmp_ppu_variable_display_price_after_tax', array($this, 'get_yith_product_sale_price_with_tax'), $this->hook_priority, 2);
			//These are not used yet.
            add_filter('mcmp_ppu_variable_min_sale_price_before_tax', array($this, 'get_yith_product_min_sale_price'), $this->hook_priority, 2);
			add_filter('mcmp_ppu_variable_max_sale_price_before_tax', array($this, 'get_yith_product_max_sale_price'), $this->hook_priority, 2);
			
            add_filter('mcmp_ppu_avail_variation_sale_price_before_tax', array($this, 'get_yith_product_min_sale_price'), $this->hook_priority, 2);
		}
		
		/**
		 * Loads YITH classes to be ready
		 */
		public function load_yith_classes(){
			$this->yith_frontend_obj = \YITH_WC_Dynamic_Pricing_Frontend::get_instance();			
		}

        /**
         * Returns the cart item price after taxes were applied.
		 * If the sale wasn't applied returns 
         *
         * @param  float $price - Price of the product.
         * @param  object $product_data - Cart product data.
         * @return mixed
         * @since  2.1.1
         */
        public function get_yith_cart_regular_price($price, $product, $product_data)
        {
			$price = false;
			if(array_key_exists('ywdpd_discounts',$product_data) && array_key_exists('default_price', $product_data['ywdpd_discounts'])){
				foreach ( $product_data['ywdpd_discounts'] as $discount ) {
					if ( isset( $discount['status'] ) && 'applied' == $discount['status'] ) {
						$price = $product_data['ywdpd_discounts']['default_price'];
					}
				}
			}
            return $price;
		}
		
        /**
         * Returns YITH minimum price
         *
         * @param  object $product - Concerned product.
         * @return float
         * @since  2.1.3
         */
        public function get_yith_frontend_min_price($product)
        {
			$yith_front_obj = YITH_WC_Dynamic_Pricing_Frontend();
			$had_filter = remove_filter( 'woocommerce_product_get_price', array( $yith_front_obj, 'get_price' ), 10 );
			$had_var_filter = remove_filter( 'woocommerce_product_variation_get_price', array( $yith_front_obj, 'get_price' ), 10 );

			if ('max' == get_option ('ywdpd_show_as_default', 'min' )){
				$price = $this->yith_frontend_obj->get_minimum_price( $product );
			} else {
				$price = $this->yith_frontend_obj->get_minimum_price( $product, 1 );
			}

			if ( $had_filter) {
				add_filter( 'woocommerce_product_get_price', array( $yith_front_obj, 'get_price' ), 10, 2 );
			}
			if ( $had_var_filter) {
				add_filter( 'woocommerce_product_variation_get_price', array( $yith_front_obj, 'get_price' ), 10, 2 );
			}
			return $price;
		}

        /**
         * Returns YITH maximum price
         *
         * @param  object $product - Concerned product.
         * @return float
         * @since  2.1.3
         */
        public function get_yith_frontend_max_price($product)
        {
			$yith_front_obj = YITH_WC_Dynamic_Pricing_Frontend();
			$had_filter = remove_filter( 'woocommerce_product_get_price', array( $yith_front_obj, 'get_price' ), 10 );
			$had_var_filter = remove_filter( 'woocommerce_product_variation_get_price', array( $yith_front_obj, 'get_price' ), 10 );

			if ('max' == get_option ('ywdpd_show_as_default', 'min' )){
				$price = $this->yith_frontend_obj->get_maximum_price( $product );
			} else {
				$price = $this->yith_frontend_obj->get_maximum_price( $product, 1 );
			}

			if ( $had_filter) {
				add_filter( 'woocommerce_product_get_price', array( $yith_front_obj, 'get_price' ), 10, 2 );
			}
			if ( $had_var_filter) {
				add_filter( 'woocommerce_product_variation_get_price', array( $yith_front_obj, 'get_price' ), 10, 2 );
			}
			return $price;
		}

        /**
         * Returns product minimum sale price with tax
         *
         * @param  float $price - Price of the product.
         * @param  integer $product_id - ID of concerned product.
         * @return float
         * @since  2.1.1
         */
        public function get_yith_product_sale_price_with_tax($price, $product_id)
        {
			$product = wc_get_product($product_id);
			if ( ! YITH_WC_Dynamic_Pricing()->check_discount( $product ) || YITH_WC_Dynamic_Pricing_Helper()->is_in_exclusion_rule( array( 'product_id' => $product_id ) ) || apply_filters( 'ywdpd_get_price_html_exclusion', false, $price, $product )){
				return $price;
			}
			$price = $this->get_yith_frontend_min_price( $product );
			$price = wc_get_price_to_display($product, array('price' => $price));
            return $price;
		}

        /**
         * Returns product minimum sale price
         *
         * @param  float $price - Price of the product.
         * @param  object $product - Concerned product.
         * @return float
         * @since  2.1.1
         */
        public function get_yith_product_min_sale_price($price, $product)
        {
			if ( ! YITH_WC_Dynamic_Pricing()->check_discount( $product ) || YITH_WC_Dynamic_Pricing_Helper()->is_in_exclusion_rule( array( 'product_id' => $product->get_id() ) ) || apply_filters( 'ywdpd_get_price_html_exclusion', false, $price, $product )){
				return $price;
			}
			$price = $this->get_yith_frontend_min_price( $product );
            return floatval($price);
		}
		
        /**
         * Returns product maximum sale price
         *
         * @param  float $price - Price of the product.
         * @param  object $product - Concerned product.
         * @return float
         * @since  2.1.1
         */
        public function get_yith_product_max_sale_price($price, $product)
        {
			if ( ! YITH_WC_Dynamic_Pricing()->check_discount( $product ) || YITH_WC_Dynamic_Pricing_Helper()->is_in_exclusion_rule( array( 'product_id' => $product->get_id() ) ) || apply_filters( 'ywdpd_get_price_html_exclusion', false, $price, $product )){
				return $price;
			}
			$price = $this->get_yith_frontend_max_price( $product );
            return floatval($price);
        }
    }
}
return YITH_Dyn_Pr_Helper::get_instance();
