<?php

namespace PPU\Helpers;

if ( ! defined( 'ABSPATH' ) ) :
	exit; // Exit if accessed directly.
endif;
/* 
 * Class containing WCPT serving functions 
 * Plug-in WooCommerce Product Table PRO
 */
if ( !class_exists( 'PPU\Helpers\WCPTHelper' ) ) {
	class WCPTHelper {

		public $hook_priority = 1010;
		public $mcmp_ppu_obj = null;
		/** Class instance */
		private static $instance = null;

		/**
		 * Returns instance of the class.
		 *
		 * @since 2.1.0
		 */
		public static function get_instance() {
			if ( null == self::$instance ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * The Constructor!
		 * @since 2.1.0
		 */
		public function __construct()
		{
			$hook_priority = intval(get_option('_mcmp_ppu_hook_priority'));
            if(!empty($hook_priority)){
                $this->hook_priority = $hook_priority;
			}
			add_filter('wcpt_element_markup', array($this, 'wcpt_templates_support'), $this->hook_priority, 2);
			add_filter('mcmp_ppu_element_classes', array($this,'get_element_classes'),10,1);
			if ( 'yes' == get_option('_mcmp_ppu_var_display_option_recalc') ){
				add_filter('wcpt_select_variation_label_for_dropdown_option', array($this, 'wcpt_variation_template_support'), $this->hook_priority, 3);
				add_filter('wcpt_select_variation_label_for_input_radio', array($this, 'wcpt_variation_template_support'), $this->hook_priority, 3);
			}
			$this->mcmp_ppu_obj = \PPU\mcmp_PPU_pro::get_instance();
		}

		/**
		 * Hooks on WCPT template processing and adds the PPU functionality
		 *
		 * @param string 
		 * @param array
		 * @return string
		 * @since 2.1.0
		 */
		public function wcpt_templates_support($element_markup, $element) {

			if(array_key_exists('type',$element)){
				if('price'==$element['type']){
					$element_markup = $this->mcmp_ppu_obj->custom_price($element_markup, null);
				}
			}
			return $element_markup;
		}

		/**
		 * Hooks on WCPT variation template processing and adds the PPU functionality
		 *
		 * @param string 
		 * @param array
		 * @return string
		 * @since 2.1.0
		 */
		public function wcpt_variation_template_support($element_markup, $variation, $element = array()) {
			$text_price = '';
			if(array_key_exists('variation_id',$variation) ){
				if( array_key_exists('hide_price', $element )){
					$hide_price = $element['hide_price'];
				}else{
					$hide_price = false;
				}
				if( false == $hide_price){
					$variation_id = $variation['variation_id'];
					$recalc_price = $this->mcmp_ppu_obj->calculate_product_price( $variation_id, true );
					if(!empty($recalc_price)){
						if( doing_filter('wcpt_select_variation_label_for_dropdown_option')){
							$text_price = ' (' .strip_tags( $this->mcmp_ppu_obj->render_recalc_text($variation_id, wcpt_price($recalc_price), false, false) ) . ')';
						}else{
							$text_price = '<span class="mcmp_var_recalc_price"> (' . $this->mcmp_ppu_obj->render_recalc_text($variation_id, wcpt_price($recalc_price)) . ')</span>';
						}
					}
				}
			}
			return $element_markup . $text_price;
		}

		/**
		 * Filters classes for individual PPU elements depending on used hook
		 * @param string $classes - Existing classes
		 * @return string 
		 * @since 2.1.0
		 */
		public function get_element_classes($classes = ''){
			if(doing_filter('wcpt_element_markup') || doing_filter('wcpt_product_var_price')) {
				$classes = '';
			}
			return $classes;
		}
	}
}
return WCPTHelper::get_instance();